global script_node

local controls = FindNodeByName("AllControlsScript")
local prop = FindNodeByName("Ob_1_2Prop")
local prop1 = FindNodeByName("lights_prop")
local handlestate

handlestate = 0

-- space/time throttle

global function AnimDone()
	local anim 
	local lights_on = FindNodeByShortName("EM_ANIMATOR_Lights_Anim_Throttle_lights_idle_on")	
	local lights_off = FindNodeByShortName("EM_ANIMATOR_Lights_Anim_Throttle_lights_idle_off")	
	
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_Space_Anim_TARDIS_Interior")	
		prop1:PlayAnim(lights_off,1,0)
	else
		anim = FindNodeByShortName("EM_ANIMATOR_Space_Anim_Space_Throttle_Up_Idle")
		prop1:PlayAnim(lights_on,1,0)	
	end
	
	prop:PlayAnim(anim, 1, 0)
	controls.script.TurnOnInterface()	
	--Locking down mech
	controls.script.InteractDone()
end

global function PlayUp()
	local anim = FindNodeByShortName("EM_ANIMATOR_Space_Anim_Space_Throttle_Up")
	local lights_up = FindNodeByShortName("EM_ANIMATOR_Lights_Anim_Throttle_lights_up")

	handlestate = 1

	FindNodeByName("Ob1_2SoundUp"):Trigger()
	prop1:PlayAnim(lights_up,1,0)
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function PlayDown()
	local anim = FindNodeByShortName("EM_ANIMATOR_Space_Anim_Space_Throttle_Down")
	local lights_down = FindNodeByShortName("EM_ANIMATOR_Lights_Anim_Throttle_lights_down")
	
	handlestate = 0

	FindNodeByName("Ob1_2SoundDown"):Trigger()
	prop1:PlayAnim(lights_down,1,0)	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function Interact()
	local doctor = GetActor("doctor")
	local amy = GetActor("amy")
	
	controls.script.TurnOffInterface()
	
	if (handlestate == 0) then
		PlayUp()
	else
		PlayDown()
	end
	
	FindNodeByName("Console1InteractableScript").script.Object2State = handlestate
	
	-- ConsoleDV == 0 is for when exploring tardis
	if controls.script.ConsoleDV == 0 then
		SayPrep("skip","async")

		if(FindNodeByName("CommonScripts").script.DoctorIsPlayer()) then
			--VO Console Control Text
			doctor::SID_2243:Space/Time Throttle: This adjusts the speed of travel through space and time, either separately or simultaneously.
			doctor::SID_2244:Supposed to move them slowly for a smooth flight. But where's the fun in that?
		else
			--VO Console Control Text
			amy::SID_2245:Looks like the throttle on a plane. I went on a simulator once, it was brilliant. I can use this to go faster or slower.
		end
	end

	if (handlestate == 1) then
		local CombinationScriptControl

		CombinationScriptControl = FindNodeByName("CombinationScriptControl")
		-- don't know why but only works if ran outside of console3object1 script
		RunAsync(CombinationScriptControl, "Console3Object1OnAudio")
	end
end

global function DummyCallback()
end

global function ResetControl()
	local lights_to_off = FindNodeByShortName("EM_ANIMATOR_Lights_Anim_Throttle_lights_down")	
	local lights_off = FindNodeByShortName("EM_ANIMATOR_Lights_Anim_Throttle_lights_idle_off")
	local anim
	
	if handlestate == 0 then
		anim = FindNodeByShortName("EM_ANIMATOR_Space_Anim_TARDIS_Interior")
		prop1:PlayAnim(lights_off,1,0)
	else
		anim = FindNodeByShortName("EM_ANIMATOR_Space_Anim_Space_Throttle_Down")
		prop1:PlayAnim(lights_to_off,1,0)
	end

	prop:SetCallback(script_node, "DummyCallback")	-- overrides the current callback so nothing happens
	prop:PlayAnim(anim, 1, 0.5)
	handlestate = 0
end
